﻿using System.Collections.Generic;

namespace Microscopic_Traffic_Simulator___Model.CellularTopologyObjects.CellWalkers
{
    /// <summary>
    /// Abstract class for returning cells by walking through topology.
    /// </summary>
    abstract class CellWalker
    {
        /// <summary>
        /// Cell from the walk starts.
        /// </summary>
        protected Cell cell;

        /// <summary>
        /// Constructor of the cell walker.
        /// </summary>
        /// <param name="cell">Cell from the walk starts.</param>
        internal CellWalker(Cell cell)
        {
            this.cell = cell;
        }

        /// <summary>
        /// Method for obtaining walked cells.
        /// </summary>
        /// <returns>Walked cells.</returns>
        internal abstract IEnumerable<Cell> GetNext();
    }
}
